function xprime=statetrackingm_derivatives(t,x)

global k1 k icon rho w  xs xsr tstart grad truegrad dt CovnT DeltaT fpre xpre ts tsr lambda;
global usave tsave 

x1=x(1);
x2=x(2);

z1=x1;
z2=-x1+x2;

dt=t-tstart;

if t==0  
   error=0; dt=2; truegrad=0;
else
   error=norm(x-xs);
end

% the threshold is determined from the robust analysis
if icon==1
   thresh=norm(truegrad)/20000
else
    thresh=norm(truegrad)/20
end

if (dt>=CovnT & error <=thresh) %| (dt>DeltaT)% & error <1) 
%if (error <=thresh) | (dt>DeltaT)% & error <1) 

if icon==1 
      
   % Banana Function
%   [f,grad]=banana(x);  % obtain function value and gradient
   
   [f,truegrad]=banana(x)
   
   % gradient estimation
   if t==0  
      grad=rand(1,2);%[0,0]; 
      xpre=x;
      fpre=f;
   else
      grad=(f-fpre)./[x-xpre];
      xpre=x;
      fpre=f;
   end
   
   
   % perform an inexact line search satifiying Armijo condition
   % a maximum limit of 50 trial of step size is posted
   % ideally we should impose such a limitation
%    alpha1=1; 
%    for k=1:50     
%        if banana([x1+alpha1*(-grad(1)),x2+alpha1*(-grad(2))]) <= f+rho*alpha1*(-grad.')*grad
%           break;
%        end
%        alpha1=w*alpha1; 
%    end
 %   if norm(grad)>=200;
 %   alpha1=0.0002; 
 %   else
 %       alpha1=0.003;
 %   end
 if t==0
     alpha1=0.00001;
 else
     alpha1=0.00002*500/norm(grad);
 end
 
 %alpha1=0.0003;   

elseif icon==0  
   % another cost function   
   f=5*x1^2 + x2^2 + 4*x1*x2-14*x1-6*x2+20;
   % gradient estimation
   if t==0  
      grad=rand(1,2);%[0,0]; 
      xpre=x;
      fpre=f;
   else
      grad=(f-fpre)./[x-xpre];
      xpre=x;
      fpre=f;
   end
   
   
   %grad=[10*x1+4*x2-14;2*x2+4*x1-6];
   %alpha1=((-grad(1))^2+(-grad(2))^2)/(2*(5*(-grad(1))^2+(-grad(2))^2+4*(-grad(1))*(-grad(2))));
   alpha1=0.01;
else
   grad=[2*(1-x1)-4*(x2-x1.^2)*x1;2*(x2-x1.^2)];
   alpha1=0.05;
end



    
% obtained step length
alpha2=alpha1;
xs=[x1-alpha1*grad(1);x2-alpha2*grad(2)];   % ideal search destination
xsr(:,end+1)=xs;
tstart=t;
end

% generate the desired set point
zs(1)=xs(1);
zs(2)=-xs(1)+xs(2);

% generate a periodic refernce trajectory
a2=zs(1);
w1=2*pi/ts;
a1=zs(2)/w1;

zs1=a1*sin(w1*t)+a2;
zs2=a1*w1*cos(w1*t);
zs3=-a1*w1*w1*sin(w1*t);

% error systems
e=k1*(z1-zs1)+(z2-zs2);
xi=k1*(z2-zs2)-zs3;

u=-xi+(-x1+x2)-x1*x2-k*e;

% Norminal Controller
% step length is 0.001, CovnT=1,  DeltaT=3
% k1=3; k=3;

% Stabilizing Term
% For smooth version of the nonlinear damping term
% step length is 0.0005, CovnT=1,  DeltaT=3, disturbance is 3 
% k1=1; k=1;
% us=-4*e/(abs(e)+0.1); 

% Stabilizing term for unbounded disturbance
% k1=3, k-1.5, eta=2; 
% step length is 0.001, CovnT=1,  DeltaT=3, disturbance is
% 1/(abs(x1)+0.01)+3*(cos(t)+1)*(x2))
% us=-eta*e*(1/(abs(z1)+0.01)+6*(z1+z2))^2;


%us=-3*e/(abs(e)+0.05);
%us=-3*sign(e);%
%eta=2;
%us=-eta*e*(1/(abs(z1)+0.01)+6*(z1+z2))^2;


%u=u+us;

% Plant dynamics
xprime(1)=-x1+x2;
xprime(2)=x1*x2+u;
% with bounded input disturbance 
% xprime(2)=x1*x2+(u+5*rand(1)); 
% with unbounded input disturbance
%xprime(2) = x1*x2+(u+1/(abs(x1)+0.01)+3*(cos(t)+1)*(x2));

xprime=xprime.';


tsave = [tsave;t];
usave = [usave;u];